/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.updater;

import com.awesome.iq.downloader.Downloader;
import com.awesome.iq.downloader.DownloaderEvent;
import com.awesome.iq.gdialog.GDialog;
import com.awesome.iq.paths.PathsProvider;
import com.awesome.iq.shared.Shared;
import com.awesome.iq.updater.StartPointPathSupplier;
import com.awesome.iq.updater.UpdateMessage;
import com.awesome.iq.updater.Updater;
import com.awesome.iq.updater.Utils;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.control.Option;
import java.awt.Taskbar;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static String globalAppPath;
    public static String globalSystemTempPath;
    public static String globalSystemRessourcePath;
    public static String globalAppName;
    public static String globalAppJAR;
    public static String globalRessourceDir;
    public static String globalOS;
    public static String globalAppNameFile;
    private static long startTime;
    private static long totalDownloadedSize;
    private static long deltaDownloadedProgressSize;
    private static long totalSize;
    private static long beginTime;
    private static final PathsProvider PATHS_PROVIDER;
    private static final StartPointPathSupplier START_POINT;

    public static void main(String[] args) {
        log.trace("start");
        try {
            globalOS = Utils.getOS();
            Main.getGlobalPath(args);
            Main.loadMacIcon();
            File theDir = new File(globalSystemTempPath);
            if (!theDir.exists() && !theDir.mkdirs()) {
                log.trace("Main.main : Unable to create directory or it already exists " + globalSystemTempPath);
            }
            Main.copyLauncherToAppData();
            Updater.main(args);
            log.trace("Main.main : exit");
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
    }

    public static void copyLauncherToAppData() {
        try {
            FileUtils.copyFile(new File(globalAppPath + START_POINT.jarName()), PATHS_PROVIDER.getGlobalAppPath().resolve("l.jar").toFile());
            FileUtils.copyFile(new File(globalAppPath + globalAppNameFile), PATHS_PROVIDER.getGlobalAppPath().resolve(globalAppNameFile).toFile());
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown", e);
        }
    }

    public static void startIQUALIF() {
        log.debug("start");
        try {
            Utils.startIQUALIF(PATHS_PROVIDER.getGlobalAppPath().resolve(globalAppJAR).toString(), globalAppName, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
    }

    public static void loadMacIcon() {
        if (globalOS.contentEquals("mac")) {
            try {
                System.setProperty("apple.awt.application.name", globalAppName);
                System.setProperty("java.awt.application.name", globalAppName);
                System.setProperty("darklaf.application.name", globalAppName);
                System.setProperty("-Xdock:name", globalAppName);
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", globalAppName);
                Taskbar taskbar = Taskbar.getTaskbar();
                BufferedImage image = ImageIO.read(Main.class.getResource("/icon.png"));
                taskbar.setIconImage(image);
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.error("Failed to set dock icon: " + e);
            }
        }
    }

    public static void getGlobalPath(String[] args) {
        log.debug("start");
        try {
            globalAppPath = START_POINT.startingDir() + File.separator;
            Shared.setGlobalSystemImagePath(globalAppPath);
            Main.getGlobalAppName();
            globalSystemTempPath = System.getProperty("java.io.tmpdir") + File.separator + globalAppName + File.separator;
            globalSystemRessourcePath = PATHS_PROVIDER.getGlobalAppPath() + globalRessourceDir + File.separator;
            log.trace("globalAppPath " + globalAppPath);
            log.trace("globalSystemTempPath " + globalSystemTempPath);
            log.trace("globalSystemRessourcePath " + globalSystemRessourcePath);
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown: " + e.getLocalizedMessage());
        }
    }

    public static Option<String> getLocalAppName() {
        Path pathLocal = Paths.get(globalAppPath, "a");
        log.debug("pathLocal {}", (Object)pathLocal);
        String prefix = "title:";
        return Array.ofAll(Utils.fileRead(pathLocal.toFile())).find(line -> StringUtils.startsWith(line, "title:")).map(line -> StringUtils.removeStart(line, "title:")).peek(it -> log.info("title is {}", it));
    }

    public static void getGlobalAppName() {
        try {
            globalAppName = Main.getLocalAppName().get();
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.trace("An exception was thrown: " + e.getLocalizedMessage());
        }
    }

    public static void update() {
        log.debug("start");
        try {
            Map<String, Object> dialogLoadingStatic = Utils.setDialogLoadingStatic("0");
            JDialog dialog = (JDialog)dialogLoadingStatic.get("dialog0");
            JProgressBar progressBar = (JProgressBar)dialogLoadingStatic.get("pb0");
            JLabel time = (JLabel)dialogLoadingStatic.get("time0");
            ((JLabel)dialogLoadingStatic.get("file0")).setVisible(false);
            time.setVisible(false);
            progressBar.setIndeterminate(true);
            SwingUtilities.invokeLater(() -> dialog.setVisible(true));
            PropertyChangeListener totalSizeAware = evt -> {
                Integer newTotalSize = (Integer)evt.getNewValue();
                totalSize = newTotalSize.intValue();
                progressBar.setMaximum(newTotalSize);
                progressBar.setIndeterminate(false);
            };
            PropertyChangeListener beforeDownloadFile = evt -> {
                Tuple2 tuple = (Tuple2)evt.getNewValue();
                ((JLabel)dialogLoadingStatic.get("file0")).setText(tuple._2 + " " + UpdateMessage.getUpdateMessage());
            };
            PropertyChangeListener successfulDownload = evt -> {
                Long downloadedBytes = (Long)evt.getNewValue();
                Main.updateProgressBar(downloadedBytes, dialogLoadingStatic);
            };
            PropertyChangeListener beforeDownloadAll = evt -> {
                beginTime = startTime = System.currentTimeMillis();
            };
            Downloader downloader = new Downloader(PATHS_PROVIDER);
            downloader.subscribe(DownloaderEvent.TOTAL_SIZE, totalSizeAware);
            downloader.subscribe(DownloaderEvent.BEFORE_DOWNLOAD_ALL, beforeDownloadAll);
            downloader.subscribe(DownloaderEvent.BEFORE_DOWNLOAD_FILE, beforeDownloadFile);
            downloader.subscribe(DownloaderEvent.SUCCESSFUL_DOWNLOAD, successfulDownload);
            boolean downloaded = downloader.download();
            if (!downloaded) {
                GDialog.showDialog("Cannot download required files. Repeat later please.", "Error");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
    }

    private static void showEstimatedTime(long totalDownloadedSize, long currDeltaSize, long currTime, Map<String, Object> dialog) {
        long prevSize = totalDownloadedSize - currDeltaSize;
        long prevTime = beginTime;
        beginTime = currTime;
        long estimatedTime = (totalSize - totalDownloadedSize) * (beginTime - startTime) / totalDownloadedSize;
        double averageSpeed = (double)totalDownloadedSize / (double)(currTime - startTime) / 8.0;
        double instantSpeed = (double)(totalDownloadedSize - prevSize) / (double)(currTime - prevTime) / 8.0;
        double seconds = (double)estimatedTime / 1000.0;
        int second = (int)seconds % 60;
        int minute = (int)(seconds / 60.0) % 60;
        int hour = (int)(seconds / 60.0 / 60.0);
        String time = String.format("%02d:%02d:%02d", hour, minute, second);
        String speed = String.format("%.2f kB/s", instantSpeed);
        String speedA = String.format("%.2f kB/s", averageSpeed);
        ((JLabel)dialog.get("time0")).setText("<html>Estimated Time: " + time + "<br>Instant Speed: " + speed + "<br>Average Speed: " + speedA + "</html>");
    }

    public static void updateProgressBar(long progress, Map<String, Object> dialog) {
        totalDownloadedSize += progress;
        deltaDownloadedProgressSize += progress;
        long currentTime = System.currentTimeMillis();
        if (currentTime - beginTime > 1000L) {
            Main.showEstimatedTime(totalDownloadedSize, deltaDownloadedProgressSize, currentTime, dialog);
            deltaDownloadedProgressSize = 0L;
        }
        SwingUtilities.invokeLater(() -> {
            JProgressBar pb0 = (JProgressBar)dialog.get("pb0");
            int current = pb0.getValue();
            pb0.setValue(current + (int)progress);
        });
    }

    static {
        globalAppName = "IQUALIF";
        globalAppJAR = "a.jar";
        globalRessourceDir = "r";
        globalOS = "unknown";
        globalAppNameFile = "a";
        totalDownloadedSize = 0L;
        deltaDownloadedProgressSize = 0L;
        totalSize = 0L;
        PATHS_PROVIDER = new PathsProvider(() -> globalAppName);
        START_POINT = new StartPointPathSupplier();
    }
}

