/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.updater;

import com.awesome.iq.updater.Main;
import com.awesome.iq.updater.MyDialog;
import com.awesome.iq.updater.UpdateMessage;
import com.awesome.iq.updater.UpdaterProgressBarUI;
import com.awesome.iq.updater.javaservice.LinuxJavaService;
import com.awesome.iq.updater.javaservice.MacJavaService;
import com.awesome.iq.updater.javaservice.WindowsJavaService;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static void startIQUALIF(String path, final String appName, Runnable runBeforeStart) throws IOException {
        log.debug("start");
        final String javaPathArg = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        final String cmdJavaCmdMac1 = "-Xdock:name=" + Main.globalAppName;
        String cmdJavaCmdMac2 = "-Dprism.order=sw";
        String cmdJavaCmdMac3 = "-XstartOnFirstThread";
        String encodingArg = "-Dfile.encoding=utf-8";
        String restrictedHeaders = "-Dsun.net.http.allowRestrictedHeaders=true";
        final Optional<String> maxHeapArg = Utils.getMaxHeapArgument();
        String jarArg = "-jar";
        final String applicationPathArg = path;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        String OS = Utils.getOS();
                        log.trace("OS = " + OS);
                        Array<String> osBasedCommand = OS.contentEquals("mac") ? Array.of(Utils.getPathMacOS(javaPathArg), cmdJavaCmdMac1, "-Dprism.order=sw") : (OS.contentEquals("windows") ? Array.of(Utils.getPathWinOS(javaPathArg)) : (OS.contentEquals("linux") ? Array.of(Utils.getPathLinuxOS(javaPathArg)) : Array.of(javaPathArg)));
                        Function<Seq, Seq> commandToRunBuilder = ipvArg -> maxHeapArg.map(osBasedCommand::append).orElse(osBasedCommand).append("-Dfile.encoding=utf-8").append("-Dapp.name=" + appName).append("-Dsun.net.http.allowRestrictedHeaders=true").appendAll((Iterable<String>)ipvArg).append("-jar").append(applicationPathArg);
                        Seq chosenIpvArg = Utils.chooseIpvSettings(commandToRunBuilder);
                        Seq commandToRun = commandToRunBuilder.apply(chosenIpvArg);
                        log.trace("commandToRun.mkString(\"[\", \" \", \"]\") = " + commandToRun.mkString("[", " ", "]"));
                        log.debug("final command : {}", (Object)commandToRun.mkString("[", " ", "]"));
                        Runtime.getRuntime().exec(commandToRun.toJavaList().toArray(new String[commandToRun.size()]));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        log.error("An exception was thrown" + e);
                    }
                }
            });
            if (runBeforeStart != null) {
                runBeforeStart.run();
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("An exception was thrown", e);
            throw new IOException("Error while trying to restart the application", e);
        }
    }

    private static Seq<String> chooseIpvSettings(Function<Seq<String>, Seq<String>> commandToRunBuilder) throws IOException, InterruptedException {
        String SUCCESS_MARKER = "< License Checker Service is REACHABLE >";
        long PROBE_TIMEOUT_MS = 15000L;
        io.vavr.collection.List<Seq> probeIpvArgs = io.vavr.collection.List.of(io.vavr.collection.List.empty(), io.vavr.collection.List.of("-Djava.net.preferIPv6Addresses=false"), io.vavr.collection.List.of("-Djava.net.preferIPv4Stack=true"));
        Seq<String> chosenIpvArg = io.vavr.collection.List.empty();
        for (Seq ipvArg : probeIpvArgs) {
            Seq<String> commandToRun = commandToRunBuilder.apply(ipvArg).append("ping");
            CharSequence[] cmdArray = commandToRun.toJavaList().toArray(new String[commandToRun.size()]);
            log.info("[ping-probe] Launching: {}", (Object)String.join((CharSequence)" ", cmdArray));
            try {
                ProcessBuilder pb = new ProcessBuilder((String[])cmdArray);
                pb.redirectErrorStream(true).inheritIO();
                Process probe = pb.start();
                boolean finished = probe.waitFor(15000L, TimeUnit.MILLISECONDS);
                if (!finished) {
                    probe.destroyForcibly();
                }
                int exitStatusCode = probe.exitValue();
                log.info("[ping-probe] Exit code: {}", (Object)exitStatusCode);
                if (exitStatusCode != 0) continue;
                chosenIpvArg = ipvArg;
                break;
            }
            catch (Throwable e) {
                log.error("An exception during app launch was thrown", e);
            }
        }
        return chosenIpvArg;
    }

    private static String getPathWinOS(String defaultPath) {
        log.debug("start");
        try {
            List<String> preferredVersions = Arrays.asList("LibericaJDK-16-Full", "LibericaJRE-11-Full", "LibericaJRE-8-Full", "jdk1.8.0_291", "jre1.8.0_291", "jdk1.8.0_261", "jre1.8.0_261", "jdk-10.0.2", "jre-10.0.1", "jdk-10.", "jre-10.", "jdk1.8", "jre1.8", "1.8");
            List<Path> javaPaths = new WindowsJavaService().getJavaPaths();
            javaPaths.forEach(System.out::println);
            for (String preferredVersion : preferredVersions) {
                for (Path javaPath : javaPaths) {
                    if (!javaPath.toString().contains(preferredVersion)) continue;
                    return javaPath.toString();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
        return defaultPath;
    }

    private static String getPathMacOS(String defaultPath) {
        log.debug("start");
        try {
            List<String> preferredVersions = Arrays.asList("liberica-jre-17-full.jre", "liberica-jre-11-full.jre", "liberica-jre-8-full.jre", "jdk1.8", "jdk-8", "1.8");
            List<Path> javaPaths = new MacJavaService().getJavaPaths();
            javaPaths.forEach(System.out::println);
            for (String preferredVersion : preferredVersions) {
                for (Path javaPath : javaPaths) {
                    log.info(javaPath.toString());
                    if (!javaPath.toString().contains(preferredVersion)) continue;
                    return javaPath.toString() + "/Contents/Home/bin/java";
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
        return defaultPath;
    }

    public static String getPathLinuxOS(String defaultPath) {
        log.debug("start");
        try {
            List<String> preferredVersions = Arrays.asList("bellsoft-java8", "bellsoft-java11", "bellsoft-java16", "jdk1.8", "jdk-8", "1.8");
            List<Path> javaPaths = new LinuxJavaService().getJavaPaths();
            javaPaths.forEach(System.out::println);
            for (String preferredVersion : preferredVersions) {
                for (Path javaPath : javaPaths) {
                    log.info(javaPath.toString());
                    if (!javaPath.toString().contains(preferredVersion)) continue;
                    return javaPath.toString() + "/bin/java";
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
        return defaultPath;
    }

    private static Optional<String> getMaxHeapArgument() {
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 980L) {
            return Optional.of("-Xmx1024m");
        }
        return Optional.empty();
    }

    public static String getJavaHome() {
        Object result;
        block7: {
            log.debug("start");
            result = "";
            try {
                result = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                String OS = Utils.getOS();
                String javaVersion = System.getProperty("java.version");
                log.debug("java version +" + javaVersion);
                String cmdJavaHome1 = "/usr/libexec/java_home";
                String cmdJavaHome2 = "-V";
                if (!OS.contentEquals("mac")) break block7;
                log.debug("mac");
                if (!javaVersion.contains("1.6")) break block7;
                log.debug("java 6, trying to find java 7+");
                String[] stringBuffer = new String[]{cmdJavaHome1, cmdJavaHome2};
                List<String> home_t = Utils.executeCommand(stringBuffer);
                for (String home : home_t) {
                    if (home.contains("1.9")) {
                        log.debug("java 9 detected");
                        result = File.separator + home.substring(home.indexOf("/") + 1) + File.separator + "bin" + File.separator + "java";
                        log.debug("home : " + (String)result);
                    } else if (home.contains("1.8")) {
                        log.debug("java 8 detected");
                        result = File.separator + home.substring(home.indexOf("/") + 1) + File.separator + "bin" + File.separator + "java";
                        log.debug("home : " + (String)result);
                    } else {
                        if (!home.contains("1.7")) continue;
                        log.debug("java 7 detected");
                        result = File.separator + home.substring(home.indexOf("/") + 1) + File.separator + "bin" + File.separator + "java";
                        log.debug("home : " + (String)result);
                    }
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.error("An exception was thrown", e);
            }
        }
        return result;
    }

    public static List<String> executeCommand(String[] cmd_t) {
        log.debug("start");
        ArrayList<String> result_t = new ArrayList<String>();
        try {
            log.debug("warning, do not use to restart application or system.exit(0) won t work");
            log.debug("executing command : " + Arrays.toString(cmd_t).replace(",", ""));
            Process p = Runtime.getRuntime().exec(cmd_t);
            p.waitFor();
            try (InputStreamReader inputStreamReader = new InputStreamReader(p.getInputStream());
                 BufferedReader reader = new BufferedReader(inputStreamReader);
                 InputStreamReader errorStreamReader = new InputStreamReader(p.getErrorStream());
                 BufferedReader stdError = new BufferedReader(errorStreamReader);){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.debug("result : " + line);
                    result_t.add(line);
                }
                while ((line = stdError.readLine()) != null) {
                    log.debug("error result : " + line);
                    result_t.add(line);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown", e);
        }
        return result_t;
    }

    public static void showDialog(String string, String title) {
        log.trace("start");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JOptionPane.showConfirmDialog(null, string, Main.globalAppName + " - " + title, -1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> setDialogLoadingStatic(String index) throws IOException {
        log.debug("start");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
            log.error("An exception was thrown", e);
        }
        final MyDialog updaterDialog = new MyDialog();
        updaterDialog.setLayout(new BorderLayout());
        Image logoImage = new ImageIcon(ImageIO.read(Main.class.getResource("/icon.png"))).getImage();
        updaterDialog.setIconImage(logoImage);
        updaterDialog.setTitle(Main.globalAppName + " - Update");
        updaterDialog.setSize(480, 200);
        updaterDialog.setModal(true);
        updaterDialog.setAlwaysOnTop(true);
        updaterDialog.setLocationRelativeTo(null);
        JPanel panelTop = new JPanel();
        final JPanel panelBottom = new JPanel();
        panelBottom.setLayout(new BoxLayout(panelBottom, 1));
        panelBottom.setPreferredSize(new Dimension(480, 55));
        JPanel panelCenter = new JPanel(new GridBagLayout());
        panelCenter.setPreferredSize(new Dimension(480, 50));
        JLabel logoLabel = new JLabel(Main.globalAppName);
        ImageIcon imageIconLogo = new ImageIcon(ImageIO.read(Main.class.getResource("/logo.png")));
        logoLabel.setIcon(imageIconLogo);
        logoLabel.setFont(new Font("Dialog", 1, 20));
        JLabel textLabel = new JLabel(UpdateMessage.getUpdateMessage());
        textLabel.setFont(new Font("SansSerif", 1, 14));
        final JLabel filePathLabel = new JLabel();
        final JLabel timeLabel = new JLabel();
        final JButton buttonCancel = new JButton();
        ImageIcon iconCancelButton = new ImageIcon(ImageIO.read(Main.class.getResource("/splashscreencancel.png")));
        buttonCancel.setIcon(iconCancelButton);
        buttonCancel.setPreferredSize(new Dimension(20, 20));
        buttonCancel.setOpaque(false);
        buttonCancel.setContentAreaFilled(false);
        buttonCancel.setBorderPainted(false);
        buttonCancel.setFocusPainted(false);
        buttonCancel.setBorder(new LineBorder(Color.LIGHT_GRAY));
        buttonCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                buttonCancel.setOpaque(false);
                buttonCancel.setBorderPainted(true);
                buttonCancel.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                buttonCancel.setOpaque(true);
                buttonCancel.setBorderPainted(false);
                buttonCancel.setContentAreaFilled(false);
                buttonCancel.setFocusPainted(false);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                log.debug("cancel button pressed");
                updaterDialog.dispose();
                System.exit(0);
            }
        });
        final JProgressBar progressBar = new JProgressBar(0, 100);
        if (Utils.getOS().equals("mac")) {
            progressBar.setUI(new UpdaterProgressBarUI());
        }
        progressBar.setValue(0);
        progressBar.setPreferredSize(new Dimension(250, 14));
        AbstractAction showHideAction = new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!progressBar.isIndeterminate()) {
                    progressBar.setStringPainted(!progressBar.isStringPainted());
                    timeLabel.setVisible(progressBar.isStringPainted());
                    filePathLabel.setVisible(progressBar.isStringPainted());
                    if (!progressBar.isStringPainted()) {
                        updaterDialog.setSize(480, 200);
                        panelBottom.setPreferredSize(new Dimension(480, 55));
                    } else {
                        updaterDialog.setSize(510, 250);
                        panelBottom.setPreferredSize(new Dimension(510, 100));
                    }
                }
            }
        };
        JButton showHideButton = new JButton(showHideAction);
        showHideButton.setPreferredSize(new Dimension(0, 0));
        showHideAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
        showHideButton.getActionMap().put("showHideAction", showHideAction);
        showHideButton.getInputMap(2).put((KeyStroke)showHideAction.getValue("AcceleratorKey"), "showHideAction");
        panelTop.add(logoLabel);
        panelCenter.add(textLabel);
        JPanel progressiveBarPanel = new JPanel(new GridBagLayout());
        progressiveBarPanel.setPreferredSize(new Dimension(480, 55));
        progressiveBarPanel.add(progressBar);
        progressiveBarPanel.add(showHideButton);
        progressiveBarPanel.add(buttonCancel);
        progressiveBarPanel.setAlignmentX(0.5f);
        filePathLabel.setAlignmentX(0.5f);
        timeLabel.setAlignmentX(0.5f);
        timeLabel.setBorder(new EmptyBorder(0, 170, 10, 0));
        panelBottom.add(filePathLabel);
        panelBottom.add(progressiveBarPanel);
        panelBottom.add(timeLabel);
        updaterDialog.add((Component)panelTop, "North");
        updaterDialog.add((Component)panelCenter, "Center");
        updaterDialog.add((Component)panelBottom, "South");
        HashMap<String, Object> updateWindowComponentsMap = new HashMap<String, Object>();
        updateWindowComponentsMap.put("dialog" + index, updaterDialog);
        updateWindowComponentsMap.put("panelTop" + index, panelTop);
        updateWindowComponentsMap.put("panelBottom" + index, panelBottom);
        updateWindowComponentsMap.put("panelCenter" + index, panelCenter);
        updateWindowComponentsMap.put("logo" + index, logoLabel);
        updateWindowComponentsMap.put("text" + index, textLabel);
        updateWindowComponentsMap.put("file" + index, filePathLabel);
        updateWindowComponentsMap.put("time" + index, timeLabel);
        updateWindowComponentsMap.put("button" + index, buttonCancel);
        updateWindowComponentsMap.put("pb" + index, progressBar);
        return updateWindowComponentsMap;
    }

    public static String getOS() {
        log.trace("start");
        String result = "unknown OS";
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                log.trace("This is Windows");
                result = "windows";
            } else if (os.contains("mac")) {
                log.trace("This is Mac");
                result = "mac";
            } else if (os.contains("nix") || os.contains("nux") || os.contains("aix")) {
                log.trace("This is Unix or Linux");
                result = "linux";
            } else if (os.contains("sunos")) {
                log.trace("This is Solaris");
            } else {
                log.trace("Your OS is not support!!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean copyFile(File src, File dest) {
        log.debug("Library.copyFile: start");
        boolean result = false;
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            log.debug("Library.copyFile: file copied from " + src + " to " + dest);
            result = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown", e);
        }
        return result;
    }

    public static List<String> fileRead(File file) {
        log.debug("start");
        ArrayList<String> result_t = new ArrayList<String>();
        try {
            String encoding = Utils.getEncodind(file);
            if (encoding.contentEquals("")) {
                log.debug("Library.fileInsert: no encoding detected");
                return result_t;
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encoding);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String strLine;
                while ((strLine = bufferedReader.readLine()) != null) {
                    result_t.add(strLine);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
        log.debug("Library.fileInsert: chemin du fichier " + file.getAbsolutePath());
        return result_t;
    }

    public static String getEncodind(File file) {
        log.debug("start");
        String encoding = "UTF-8";
        try (FileInputStream fis = new FileInputStream(file);){
            int nread;
            String DEFAULT_ENCODING = "UTF-8";
            byte[] buf = new byte[4096];
            UniversalDetector detector = new UniversalDetector(null);
            while ((nread = fis.read(buf)) > 0 && !detector.isDone()) {
                detector.handleData(buf, 0, nread);
            }
            detector.dataEnd();
            encoding = detector.getDetectedCharset();
            if (encoding != null) {
                log.debug("detected encoding : " + encoding);
            } else {
                log.debug("no encoding detected");
                encoding = DEFAULT_ENCODING;
            }
            detector.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.error("An exception was thrown" + e);
        }
        return encoding;
    }
}

