/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.updater.javaservice;

import com.awesome.iq.updater.javaservice.JavaService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LinuxJavaService
implements JavaService {
    private static final Set<Path> PROGRAM_FILES_PATHS = new HashSet<Path>(Arrays.asList(Paths.get("/usr/lib/jvm", new String[0]), Paths.get("/usr/lib32/jvm", new String[0]), Paths.get("/usr/java", new String[0]), Paths.get("/usr/lib64/jvm", new String[0])));

    @Override
    public List<Path> getJavaPaths() {
        ArrayList<Path> javaPaths = new ArrayList<Path>();
        try {
            for (Path programFilesPath : PROGRAM_FILES_PATHS) {
                String process;
                Process p = Runtime.getRuntime().exec("ls " + programFilesPath);
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((process = input.readLine()) != null) {
                    javaPaths.add(Paths.get(programFilesPath + File.separator + process, new String[0]));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return javaPaths;
    }
}

