/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.downloader;

import com.awesome.iq.downloader.BatchUriDownloader;
import com.awesome.iq.downloader.ComponentVersionParser;
import com.awesome.iq.downloader.DownloaderEvent;
import com.awesome.iq.downloader.RetryAction;
import com.awesome.iq.downloader.UriDownloader;
import com.awesome.iq.paths.PathsProvider;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Try;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    private static final Logger a = LoggerFactory.getLogger(Downloader.class);
    private final PropertyChangeSupport b = new PropertyChangeSupport(this);
    private final URI c;
    private final PathsProvider d;
    private final ComponentVersionParser e = new ComponentVersionParser();

    public Downloader(URI uRI, PathsProvider pathsProvider) {
        this.c = uRI;
        this.d = pathsProvider;
    }

    public Downloader(PathsProvider pathsProvider) {
        this(URI.create("https://update.iqualif.com/nojoo/dl/iqualif2/"), pathsProvider);
    }

    public URI getMainUri() {
        return this.c;
    }

    public void subscribe(DownloaderEvent downloaderEvent, PropertyChangeListener propertyChangeListener) {
        this.b.addPropertyChangeListener(downloaderEvent.name(), propertyChangeListener);
    }

    public boolean download() {
        Object object2 = new UriDownloader(this.c.resolve(this.d.getVersionsFile()));
        if ((object2 = ((UriDownloader)object2).readLines()).isFailure()) {
            return false;
        }
        object2 = (Seq)object2.get();
        Object object3 = object2.flatMap(this.e::parse);
        Try<Integer> try_2 = this;
        try_2 = Iterator.of(StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8).map(charset -> Try.of(() -> Files.readAllLines(this.d.versionsLocalPath(), charset)).onFailure(throwable -> new StringBuilder("Cannot read with ").append(charset).append("charset"))).flatMap(Value::toOption).headOption().map(Array::ofAll).onEmpty(() -> {}).getOrElse(Array::empty).flatMap(((Downloader)((Object)try_2)).e::parse);
        try_2.mkString(",");
        Traversable traversable = object3;
        object3 = try_2;
        Object object4 = traversable;
        try_2 = this;
        object4 = object3 = object4.reject(((Array)object3)::contains).map(componentVersion -> {
            String string = Paths.get(componentVersion.getFilePath(), new String[0]).toString();
            return new Tuple2<String, Path>(this.c + componentVersion.getFilePath(), this.d.getGlobalAppPath().resolve(string));
        });
        try_2 = this;
        try_2 = Try.sequence(object4.map(Tuple2::_1).map(((Downloader)((Object)try_2))::a)).map(Traversable::sum).map(Number::intValue).onSuccess(n -> this.b.firePropertyChange(DownloaderEvent.TOTAL_SIZE.name(), (Object)0, n));
        if (try_2.isFailure()) {
            return false;
        }
        this.b.firePropertyChange(DownloaderEvent.BEFORE_DOWNLOAD_ALL.empty(this));
        boolean bl = object3.iterator().map(object -> {
            this.b.firePropertyChange(DownloaderEvent.BEFORE_DOWNLOAD_FILE.name(), new Object(), object);
            Tuple2 tuple2 = object;
            object = this;
            return RetryAction.ofBoolean(() -> new BatchUriDownloader(URI.create((String)tuple2._1), Paths.get(tuple2._2 + "_update", new String[0])).download(l -> this.b.firePropertyChange(DownloaderEvent.SUCCESSFUL_DOWNLOAD.name(), 0L, l)));
        }).exists(try_ -> try_.isFailure() || (Boolean)try_.get() == false);
        if (bl) {
            return false;
        }
        object3.map(Tuple2::_2).forEach(path -> {
            try {
                File file = new File(path + "_update");
                FileUtils.copyFile(file, path.toFile());
                FileUtils.deleteQuietly(file);
                return;
            }
            catch (IOException iOException) {
                return;
            }
        });
        try {
            FileUtils.writeLines(this.d.versionsLocalPath().toFile(), object2.toJavaList());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private Try a(String string) {
        return RetryAction.of(() -> new URL(string).openConnection().getContentLengthLong());
    }
}

