/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.updater;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class UpdaterProgressBarUI
extends BasicProgressBarUI {
    private static final Color FILL_BACKGROUND_COLOR = Color.decode("#3B88FD");
    private static final Color AREA_BACKGROUND_COLOR = Color.decode("#DDDDDD");
    private static final Color STROKE_COLOR = Color.decode("#CACACA");

    @Override
    protected Dimension getPreferredInnerVertical() {
        return new Dimension(20, 146);
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return new Dimension(146, 20);
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int strokeWidth = 2;
        g2d.setStroke(new BasicStroke(strokeWidth, 1, 1));
        int width = this.progressBar.getWidth();
        int height = this.progressBar.getHeight();
        RoundRectangle2D.Double outerOutline = new RoundRectangle2D.Double(strokeWidth / 2, strokeWidth / 2, width - strokeWidth, height - strokeWidth, height, height);
        g2d.setColor(STROKE_COLOR);
        g2d.setBackground(STROKE_COLOR);
        g2d.draw(outerOutline);
        RoundRectangle2D.Double outline = new RoundRectangle2D.Double(strokeWidth / 2, strokeWidth / 2, width - strokeWidth, height - strokeWidth, height, height);
        g2d.setColor(AREA_BACKGROUND_COLOR);
        g2d.fill(outline);
        int iInnerHeight = height;
        int iInnerWidth = width;
        double dProgress = this.progressBar.getPercentComplete();
        if (dProgress < 0.0) {
            dProgress = 0.0;
        } else if (dProgress > 1.0) {
            dProgress = 1.0;
        }
        iInnerWidth = (int)Math.round((double)iInnerWidth * dProgress);
        int margin = 4;
        RoundRectangle2D.Double fill = new RoundRectangle2D.Double(strokeWidth * 2 - margin, strokeWidth * 2 - margin, iInnerWidth, iInnerHeight, iInnerHeight - 1, iInnerHeight - 1);
        g2d.setColor(FILL_BACKGROUND_COLOR);
        g2d.fill(fill);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2d, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
        g2d.dispose();
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        this.paintDeterminate(g, c);
    }

    @Override
    protected Color getSelectionForeground() {
        return super.getSelectionForeground();
    }

    @Override
    protected Color getSelectionBackground() {
        return Color.black;
    }
}

