/*
 * Decompiled with CFR 0.152.
 */
package com.awesome.iq.updater.javaservice;

import com.awesome.iq.updater.javaservice.JavaService;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WindowsJavaService
implements JavaService {
    private static final String JAVA_EXE_FILE_NAME = "java.exe";
    private static final Set<Path> PROGRAM_FILES_PATHS = new HashSet<Path>(Arrays.asList(Paths.get(System.getenv("ProgramFiles").replace(" (x86)", ""), "BellSoft"), Paths.get(System.getenv("ProgramFiles(x86)"), "BellSoft"), Paths.get(System.getenv("ProgramFiles").replace(" (x86)", ""), "Java"), Paths.get(System.getenv("ProgramFiles(x86)"), "Java")));

    @Override
    public List<Path> getJavaPaths() {
        ArrayList<Path> javaPaths = new ArrayList<Path>();
        PROGRAM_FILES_PATHS.forEach(el -> {
            try (Stream<Path> walk2 = Files.walk(el, new FileVisitOption[0]);){
                List tempRes = walk2.filter(path -> path.getParent().toFile().getName().equals("bin") && JAVA_EXE_FILE_NAME.equals(path.toFile().getName())).collect(Collectors.toList());
                javaPaths.addAll(tempRes);
            }
            catch (NoSuchFileException walk2) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return javaPaths;
    }
}

